/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.serverbound;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.packets.serverbound.ImportMusicSendPacket;

public record MusicUpdatePacket(FieldFlag availability, ArrayList<NoteEvent> notes, short lengthBeats, byte bps, float volume, boolean signed, String title, byte prevInstrument, boolean prevInsLocked, UUID id, int version, byte highlightInterval) implements class_8710
{
    public static final class_8710.class_9154<MusicUpdatePacket> PACKET_ID = new class_8710.class_9154(Mod.id("music_update"));
    public static final class_9139<class_2540, MusicUpdatePacket> PACKET_CODEC = class_9139.method_56438(MusicUpdatePacket::encode, MusicUpdatePacket::decode);

    public static MusicUpdatePacket create(FieldFlag availability, ArrayList<NoteEvent> notes, short lengthBeats, byte bps, float volume, boolean signed, String title, byte prevInstrument, boolean prevInsLocked, UUID id, int version, byte highlightInterval) throws ImportMusicSendPacket.NotesTooLargeException {
        if (notes != null && notes.size() > 5000) {
            throw new ImportMusicSendPacket.NotesTooLargeException(notes, id);
        }
        return new MusicUpdatePacket(availability, notes, lengthBeats, bps, volume, signed, title, prevInstrument, prevInsLocked, id, version, highlightInterval);
    }

    public static MusicUpdatePacket decode(class_2540 buf) {
        try {
            int eventCount;
            FieldFlag flag = FieldFlag.fromInt(buf.readInt());
            ArrayList<NoteEvent> notes = null;
            short lengthBeats = 0;
            byte bps = 0;
            float volume = 0.0f;
            boolean signed = false;
            String title = null;
            byte prevInstrument = 0;
            boolean prevInsLocked = false;
            UUID id = null;
            int version = 0;
            byte highlightInterval = 0;
            if (flag.hasTitle) {
                title = buf.method_10800(255);
            }
            if (flag.hasSigned) {
                signed = buf.readBoolean();
            }
            if (flag.hasBps) {
                bps = buf.readByte();
            }
            if (flag.hasVolume) {
                volume = buf.readFloat();
            }
            if (flag.hasLength) {
                lengthBeats = buf.readShort();
            }
            if (flag.hasNotes && (eventCount = buf.readInt()) != 0) {
                notes = new ArrayList<NoteEvent>(eventCount);
                for (int i = 0; i < eventCount; ++i) {
                    notes.add(NoteEvent.fromBuffer(buf));
                }
            }
            if (flag.hasPrevIns) {
                prevInstrument = buf.readByte();
            }
            if (flag.hasPrevInsLocked) {
                prevInsLocked = buf.readBoolean();
            }
            if (flag.hasId) {
                id = buf.method_10790();
            }
            if (flag.hasVersion) {
                version = buf.readInt();
            }
            if (flag.hasHlInterval) {
                highlightInterval = buf.readByte();
            }
            return MusicUpdatePacket.create(flag, notes, lengthBeats, bps, volume, signed, title, prevInstrument, prevInsLocked, id, version, highlightInterval);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading MusicUpdatePacket: " + String.valueOf(ioe));
            return null;
        }
        catch (ImportMusicSendPacket.NotesTooLargeException e) {
            System.err.println("NotesTooLargeException while reading MusicUpdatePacket: " + String.valueOf(e));
            return null;
        }
    }

    public class_2540 encode(class_2540 buf) {
        buf.method_53002(this.availability.toInt());
        if (this.availability.hasTitle) {
            buf.method_10814(this.title);
        }
        if (this.availability.hasSigned) {
            buf.method_52964(this.signed);
        }
        if (this.availability.hasBps) {
            buf.method_52997((int)this.bps);
        }
        if (this.availability.hasVolume) {
            buf.method_52941(this.volume);
        }
        if (this.availability.hasLength) {
            buf.method_52998((int)this.lengthBeats);
        }
        if (this.availability.hasNotes) {
            if (this.notes != null) {
                buf.method_53002(this.notes.size());
                for (NoteEvent event : this.notes) {
                    event.encodeToBuffer(buf);
                }
            } else {
                buf.method_53002(0);
            }
        }
        if (this.availability.hasPrevIns) {
            buf.method_52997((int)this.prevInstrument);
        }
        if (this.availability.hasPrevInsLocked) {
            buf.method_52964(this.prevInsLocked);
        }
        if (this.availability.hasId) {
            buf.method_10797(this.id);
        }
        if (this.availability.hasVersion) {
            buf.method_53002(this.version);
        }
        if (this.availability.hasHlInterval) {
            buf.method_52997((int)this.highlightInterval);
        }
        return buf;
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    public static class FieldFlag {
        private static final int notesFlag = 1;
        private static final int lengthFlag = 2;
        private static final int bpsFlag = 4;
        private static final int volumeFlag = 8;
        private static final int signedFlag = 16;
        private static final int titleFlag = 32;
        private static final int prevInsFlag = 64;
        private static final int prevInsLockedFlag = 128;
        private static final int idFlag = 256;
        private static final int versionFlag = 512;
        private static final int hlIntervalFlag = 1024;
        public boolean hasNotes;
        public boolean hasLength;
        public boolean hasBps;
        public boolean hasVolume;
        public boolean hasSigned;
        public boolean hasTitle;
        public boolean hasPrevIns;
        public boolean hasPrevInsLocked;
        public boolean hasId;
        public boolean hasVersion;
        public boolean hasHlInterval;

        public FieldFlag(boolean hasNotes, boolean hasLength, boolean hasBps, boolean hasVolume, boolean hasSigned, boolean hasTitle, boolean hasPrevIns, boolean hasPrevInsLocked, boolean hasId, boolean hasVersion, boolean hasHlInterval) {
            this.hasNotes = hasNotes;
            this.hasLength = hasLength;
            this.hasBps = hasBps;
            this.hasVolume = hasVolume;
            this.hasSigned = hasSigned;
            this.hasTitle = hasTitle;
            this.hasPrevIns = hasPrevIns;
            this.hasPrevInsLocked = hasPrevInsLocked;
            this.hasId = hasId;
            this.hasVersion = hasVersion;
            this.hasHlInterval = hasHlInterval;
        }

        public FieldFlag() {
        }

        public int toInt() {
            return (this.hasNotes ? 1 : 0) | (this.hasLength ? 2 : 0) | (this.hasBps ? 4 : 0) | (this.hasVolume ? 8 : 0) | (this.hasSigned ? 16 : 0) | (this.hasTitle ? 32 : 0) | (this.hasPrevIns ? 64 : 0) | (this.hasPrevInsLocked ? 128 : 0) | (this.hasId ? 256 : 0) | (this.hasVersion ? 512 : 0) | (this.hasHlInterval ? 1024 : 0);
        }

        public static FieldFlag fromInt(int packed) {
            return new FieldFlag((packed & 1) != 0, (packed & 2) != 0, (packed & 4) != 0, (packed & 8) != 0, (packed & 0x10) != 0, (packed & 0x20) != 0, (packed & 0x40) != 0, (packed & 0x80) != 0, (packed & 0x100) != 0, (packed & 0x200) != 0, (packed & 0x400) != 0);
        }

        public boolean hasAny() {
            return this.hasNotes || this.hasLength || this.hasBps || this.hasVolume || this.hasSigned || this.hasTitle || this.hasPrevIns || this.hasPrevInsLocked || this.hasId || this.hasVersion || this.hasHlInterval;
        }

        public String toString() {
            return (this.hasNotes ? "Notes, " : "") + (this.hasLength ? "Length, " : "") + (this.hasBps ? "Bps, " : "") + (this.hasVolume ? "Volume, " : "") + (this.hasSigned ? "Signed, " : "") + (this.hasTitle ? "Title, " : "") + (this.hasPrevIns ? "PrevIns, " : "") + (this.hasPrevInsLocked ? "PrevInsLocked, " : "") + (this.hasId ? "Id, " : "") + (this.hasVersion ? "Version, " : "") + (this.hasHlInterval ? "HL Interval" : "");
        }
    }
}

